/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.util;

import java.util.StringTokenizer;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultLineTracker;
import org.eclipse.jface.text.IRegion;

public class Strings {
    private Strings() {
    }

    public static boolean isIndentChar(char ch) {
        return Character.isWhitespace(ch) && !Strings.isLineDelimiterChar(ch);
    }

    public static boolean isLowerCase(char ch) {
        return Character.toLowerCase(ch) == ch;
    }

    public static boolean isLineDelimiterChar(char ch) {
        return ch == '\n' || ch == '\r';
    }

    public static String removeNewLine(String message) {
        StringBuffer result = new StringBuffer();
        int current = 0;
        int index = message.indexOf(10, 0);
        while (index != -1) {
            result.append(message.substring(current, index));
            if (current < index && index != 0) {
                result.append(' ');
            }
            current = index + 1;
            index = message.indexOf(10, current);
        }
        result.append(message.substring(current));
        return result.toString();
    }

    public static String[] convertIntoLines(String input) {
        try {
            DefaultLineTracker tracker = new DefaultLineTracker();
            tracker.set(input);
            int size = tracker.getNumberOfLines();
            String[] result = new String[size];
            for (int i = 0; i < size; ++i) {
                IRegion region = tracker.getLineInformation(i);
                int offset = region.getOffset();
                result[i] = input.substring(offset, offset + region.getLength());
            }
            return result;
        }
        catch (BadLocationException e) {
            return null;
        }
    }

    public static boolean containsOnlyWhitespaces(String s) {
        int size = s.length();
        for (int i = 0; i < size; ++i) {
            if (Character.isWhitespace(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static String trimLeadingTabsAndSpaces(String line) {
        int size;
        int start = size = line.length();
        for (int i = 0; i < size; ++i) {
            char c = line.charAt(i);
            if (Strings.isIndentChar(c)) continue;
            start = i;
            break;
        }
        if (start == 0) {
            return line;
        }
        if (start == size) {
            return "";
        }
        return line.substring(start);
    }

    public static String trimTrailingTabsAndSpaces(String line) {
        char c;
        int size;
        int end = size = line.length();
        int i = size - 1;
        while (i >= 0 && Strings.isIndentChar(c = line.charAt(i))) {
            end = i--;
        }
        if (end == size) {
            return line;
        }
        if (end == 0) {
            return "";
        }
        return line.substring(0, end);
    }

    public static int computeIndent(String line, int tabWidth) {
        int result = 0;
        int blanks = 0;
        int size = line.length();
        for (int i = 0; i < size; ++i) {
            char c = line.charAt(i);
            if (c == '\t') {
                ++result;
                blanks = 0;
                continue;
            }
            if (Strings.isIndentChar(c)) {
                if (++blanks != tabWidth) continue;
                ++result;
                blanks = 0;
                continue;
            }
            return result;
        }
        return result;
    }

    public static String trimIndent(String line, int indentsToRemove, int tabWidth) {
        if (line == null || indentsToRemove <= 0) {
            return line;
        }
        int start = 0;
        int indents = 0;
        int blanks = 0;
        int size = line.length();
        for (int i = 0; i < size; ++i) {
            char c = line.charAt(i);
            if (c == '\t') {
                ++indents;
                blanks = 0;
            } else if (Strings.isIndentChar(c)) {
                if (++blanks == tabWidth) {
                    ++indents;
                    blanks = 0;
                }
            } else {
                start = i;
                break;
            }
            if (indents != indentsToRemove) continue;
            start = i + 1;
            break;
        }
        if (start == size) {
            return "";
        }
        return line.substring(start);
    }

    public static void trimIndentation(String[] lines, int tabWidth) {
        Strings.trimIndentation(lines, tabWidth, true);
    }

    public static void trimIndentation(String[] lines, int tabWidth, boolean considerFirstLine) {
        int i;
        String[] toDo = new String[lines.length];
        int minIndent = Integer.MAX_VALUE;
        int n = i = considerFirstLine ? 0 : 1;
        while (i < lines.length) {
            String line = lines[i];
            if (!Strings.containsOnlyWhitespaces(line)) {
                toDo[i] = line;
                int indent = Strings.computeIndent(line, tabWidth);
                if (indent < minIndent) {
                    minIndent = indent;
                }
            }
            ++i;
        }
        if (minIndent > 0) {
            int n2 = i = considerFirstLine ? 0 : 1;
            while (i < toDo.length) {
                String line;
                int indent;
                String s = toDo[i];
                lines[i] = s != null ? Strings.trimIndent(s, minIndent, tabWidth) : ((indent = Strings.computeIndent(line = lines[i], tabWidth)) > minIndent ? Strings.trimIndent(line, minIndent, tabWidth) : Strings.trimLeadingTabsAndSpaces(line));
                ++i;
            }
        }
    }

    public static String getIndentString(String line, int tabWidth) {
        int size = line.length();
        int end = 0;
        int blanks = 0;
        for (int i = 0; i < size; ++i) {
            char c = line.charAt(i);
            if (c == '\t') {
                end = i + 1;
                blanks = 0;
                continue;
            }
            if (!Strings.isIndentChar(c)) break;
            if (++blanks != tabWidth) continue;
            end = i + 1;
            blanks = 0;
        }
        if (end == 0) {
            return "";
        }
        if (end == size) {
            return line;
        }
        return line.substring(0, end);
    }

    public static int computeIndentLength(String line, int numberOfIndents, int tabWidth) {
        Assert.isTrue(numberOfIndents >= 0);
        Assert.isTrue(tabWidth >= 0);
        int size = line.length();
        int result = -1;
        int indents = 0;
        int blanks = 0;
        for (int i = 0; i < size && indents < numberOfIndents; ++i) {
            char c = line.charAt(i);
            if (c == '\t') {
                ++indents;
                result = i;
                blanks = 0;
                continue;
            }
            if (!Strings.isIndentChar(c)) break;
            if (++blanks != tabWidth) continue;
            result = i;
            ++indents;
            blanks = 0;
        }
        if (indents < numberOfIndents) {
            return -1;
        }
        return result + 1;
    }

    public static String[] removeTrailingEmptyLines(String[] sourceLines) {
        int lastNonEmpty = Strings.findLastNonEmptyLineIndex(sourceLines);
        String[] result = new String[lastNonEmpty + 1];
        for (int i = 0; i < result.length; ++i) {
            result[i] = sourceLines[i];
        }
        return result;
    }

    private static int findLastNonEmptyLineIndex(String[] sourceLines) {
        for (int i = sourceLines.length - 1; i >= 0; --i) {
            if (sourceLines[i].trim().equals("")) continue;
            return i;
        }
        return -1;
    }

    public static String changeIndent(String code, int codeIndentLevel, int tabWidth, String newIndent, String lineDelim) {
        try {
            DefaultLineTracker tracker = new DefaultLineTracker();
            tracker.set(code);
            int nLines = tracker.getNumberOfLines();
            if (nLines == 1) {
                return code;
            }
            StringBuffer buf = new StringBuffer();
            for (int i = 0; i < nLines; ++i) {
                IRegion region = tracker.getLineInformation(i);
                int start = region.getOffset();
                int end = start + region.getLength();
                String line = code.substring(start, end);
                if (i == 0) {
                    buf.append(line);
                    continue;
                }
                buf.append(lineDelim);
                buf.append(newIndent);
                buf.append(Strings.trimIndent(line, codeIndentLevel, tabWidth));
            }
            return buf.toString();
        }
        catch (BadLocationException e) {
            return code;
        }
    }

    public static String trimIndentation(String source, int tabWidth, boolean considerFirstLine) {
        try {
            DefaultLineTracker tracker = new DefaultLineTracker();
            tracker.set(source);
            int size = tracker.getNumberOfLines();
            if (size == 1) {
                return source;
            }
            String[] lines = new String[size];
            for (int i = 0; i < size; ++i) {
                IRegion region = tracker.getLineInformation(i);
                int offset = region.getOffset();
                lines[i] = source.substring(offset, offset + region.getLength());
            }
            Strings.trimIndentation(lines, tabWidth, considerFirstLine);
            StringBuffer result = new StringBuffer();
            int last = size - 1;
            for (int i = 0; i < size; ++i) {
                result.append(lines[i]);
                if (i >= last) continue;
                result.append(tracker.getLineDelimiter(i));
            }
            return result.toString();
        }
        catch (BadLocationException e) {
            Assert.isTrue(false, "Can not happend");
            return null;
        }
    }

    public static String concatenate(String[] lines, String delimiter) {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < lines.length; ++i) {
            if (i > 0) {
                buffer.append(delimiter);
            }
            buffer.append(lines[i]);
        }
        return buffer.toString();
    }

    public static boolean equals(String s, char[] c) {
        if (s.length() != c.length) {
            return false;
        }
        int i = c.length;
        while (--i >= 0) {
            if (s.charAt(i) == c[i]) continue;
            return false;
        }
        return true;
    }

    public static String[] splitByToken(String fullString, String splitToken) {
        StringTokenizer tokenizer = new StringTokenizer(fullString, splitToken);
        String[] tokens = new String[tokenizer.countTokens()];
        int i = 0;
        while (tokenizer.hasMoreTokens()) {
            tokens[i] = tokenizer.nextToken();
            ++i;
        }
        return tokens;
    }
}

