/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.Vector;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.DefaultSimilarity;
import org.apache.lucene.search.Searcher;

public abstract class Similarity {
    private static Similarity defaultImpl = new DefaultSimilarity();
    private static final float[] NORM_TABLE = new float[256];

    public static void setDefault(Similarity similarity) {
        defaultImpl = similarity;
    }

    public static Similarity getDefault() {
        return defaultImpl;
    }

    public static float decodeNorm(byte b) {
        return NORM_TABLE[b & 0xFF];
    }

    public abstract float lengthNorm(String var1, int var2);

    public abstract float queryNorm(float var1);

    public static byte encodeNorm(float f) {
        return Similarity.floatToByte(f);
    }

    private static float byteToFloat(byte b) {
        if (b == 0) {
            return 0.0f;
        }
        int mantissa = b & 7;
        int exponent = b >> 3 & 0x1F;
        int bits = exponent + 48 << 24 | mantissa << 21;
        return Float.intBitsToFloat(bits);
    }

    private static byte floatToByte(float f) {
        if (f < 0.0f) {
            f = 0.0f;
        }
        if (f == 0.0f) {
            return 0;
        }
        int bits = Float.floatToIntBits(f);
        int mantissa = (bits & 0xFFFFFF) >> 21;
        int exponent = (bits >> 24 & 0x7F) - 63 + 15;
        if (exponent > 31) {
            exponent = 31;
            mantissa = 7;
        }
        if (exponent < 0) {
            exponent = 0;
            mantissa = 1;
        }
        return (byte)(exponent << 3 | mantissa);
    }

    public float tf(int freq) {
        return this.tf((float)freq);
    }

    public abstract float sloppyFreq(int var1);

    public abstract float tf(float var1);

    public float idf(Term term, Searcher searcher) throws IOException {
        return this.idf(searcher.docFreq(term), searcher.maxDoc());
    }

    public float idf(Vector terms, Searcher searcher) throws IOException {
        float idf = 0.0f;
        for (int i = 0; i < terms.size(); ++i) {
            idf += this.idf((Term)terms.elementAt(i), searcher);
        }
        return idf;
    }

    public abstract float idf(int var1, int var2);

    public abstract float coord(int var1, int var2);

    static {
        for (int i = 0; i < 256; ++i) {
            Similarity.NORM_TABLE[i] = Similarity.byteToFloat((byte)i);
        }
    }
}

