/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.document;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import org.apache.lucene.document.DocumentFieldEnumeration;
import org.apache.lucene.document.DocumentFieldList;
import org.apache.lucene.document.Field;

public final class Document
implements Serializable {
    DocumentFieldList fieldList = null;
    private float boost = 1.0f;

    public void setBoost(float boost) {
        this.boost = boost;
    }

    public float getBoost() {
        return this.boost;
    }

    public final void add(Field field) {
        this.fieldList = new DocumentFieldList(field, this.fieldList);
    }

    public final Field getField(String name) {
        DocumentFieldList list = this.fieldList;
        while (list != null) {
            if (list.field.name().equals(name)) {
                return list.field;
            }
            list = list.next;
        }
        return null;
    }

    public final String get(String name) {
        Field field = this.getField(name);
        if (field != null) {
            return field.stringValue();
        }
        return null;
    }

    public final Enumeration fields() {
        return new DocumentFieldEnumeration(this);
    }

    public final Field[] getFields(String name) {
        ArrayList<Field> tempFieldList = new ArrayList<Field>();
        DocumentFieldList list = this.fieldList;
        while (list != null) {
            if (list.field.name().equals(name)) {
                tempFieldList.add(list.field);
            }
            list = list.next;
        }
        int fieldCount = tempFieldList.size();
        if (fieldCount == 0) {
            return null;
        }
        return tempFieldList.toArray(new Field[0]);
    }

    public final String[] getValues(String name) {
        Field[] namedFields = this.getFields(name);
        if (namedFields == null) {
            return null;
        }
        String[] values = new String[namedFields.length];
        for (int i = 0; i < namedFields.length; ++i) {
            values[i] = namedFields[i].stringValue();
        }
        return values;
    }

    public final String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Document<");
        DocumentFieldList list = this.fieldList;
        while (list != null) {
            buffer.append(list.field.toString());
            if (list.next != null) {
                buffer.append(" ");
            }
            list = list.next;
        }
        buffer.append(">");
        return buffer.toString();
    }
}

