/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.search;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.pde.core.plugin.IPlugin;
import org.eclipse.pde.core.plugin.IPluginExtension;
import org.eclipse.pde.core.plugin.IPluginExtensionPoint;
import org.eclipse.pde.core.plugin.IPluginImport;
import org.eclipse.pde.internal.core.ModelEntry;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.plugin.ImportObject;
import org.eclipse.pde.internal.ui.search.DependencyExtentAction;
import org.eclipse.pde.internal.ui.search.FindDeclarationsAction;
import org.eclipse.pde.internal.ui.search.FindReferencesAction;
import org.eclipse.pde.internal.ui.search.ShowDescriptionAction;
import org.eclipse.search.ui.ISearchResultViewEntry;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.actions.ActionGroup;

public class PluginSearchActionGroup
extends ActionGroup {
    public void fillContextMenu(IMenuManager menu) {
        IStructuredSelection sSelection;
        super.fillContextMenu(menu);
        ActionContext context = this.getContext();
        ISelection selection = context.getSelection();
        if (selection instanceof IStructuredSelection && (sSelection = (IStructuredSelection)selection).size() == 1) {
            Object object = sSelection.getFirstElement();
            this.addFindDeclarationsAction(object, menu);
            this.addFindReferencesAction(object, menu);
            this.addShowDescriptionAction(object, menu);
            this.addDependencyExtentAction(object, menu);
        }
    }

    private void addDependencyExtentAction(Object object, IMenuManager menu) {
        if (object instanceof ISearchResultViewEntry) {
            object = ((ISearchResultViewEntry)object).getGroupByKey();
        } else if (object instanceof ImportObject) {
            object = ((ImportObject)object).getImport();
        }
        if (object instanceof IPluginImport && ((IPluginImport)object).getModel().getUnderlyingResource() != null) {
            menu.add((IContributionItem)new Separator());
            menu.add((IAction)new DependencyExtentAction((IPluginImport)object));
        }
    }

    private void addFindDeclarationsAction(Object object, IMenuManager menu) {
        if (object instanceof ISearchResultViewEntry) {
            object = ((ISearchResultViewEntry)object).getGroupByKey();
        } else if (object instanceof ImportObject) {
            object = ((ImportObject)object).getImport();
        }
        if (object instanceof IPluginImport || object instanceof IPluginExtension) {
            menu.add((IAction)new FindDeclarationsAction(object));
        }
    }

    private void addFindReferencesAction(Object object, IMenuManager menu) {
        if (object instanceof ISearchResultViewEntry) {
            object = ((ISearchResultViewEntry)object).getGroupByKey();
        } else if (object instanceof ModelEntry) {
            object = ((ModelEntry)object).getActiveModel().getPluginBase();
        } else if (object instanceof ImportObject) {
            object = ((ImportObject)object).getImport();
        }
        if (object instanceof IPluginExtensionPoint || object instanceof IPluginImport || object instanceof IPlugin) {
            menu.add((IAction)new FindReferencesAction(object));
        }
    }

    private void addShowDescriptionAction(Object object, IMenuManager menu) {
        if (object instanceof ISearchResultViewEntry) {
            object = ((ISearchResultViewEntry)object).getGroupByKey();
        }
        if (object instanceof IPluginExtensionPoint) {
            menu.add((IAction)new ShowDescriptionAction((IPluginExtensionPoint)object));
        } else if (object instanceof IPluginExtension) {
            String pointId = ((IPluginExtension)object).getPoint();
            IPluginExtensionPoint extPoint = PDECore.getDefault().findExtensionPoint(pointId);
            if (extPoint != null) {
                menu.add((IAction)new ShowDescriptionAction(extPoint));
            }
        }
    }
}

