/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.search;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.ui.search.SearchMessages;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.ui.texteditor.IMarkerUpdater;
import org.eclipse.ui.texteditor.MarkerUtilities;

public class JavaSearchMarkerUpdater
implements IMarkerUpdater {
    public boolean updateMarker(IMarker marker, IDocument document, Position position) {
        block6: {
            try {
                String id = (String)marker.getAttribute("org.eclipse.jdt.internal.ui.search.handleID");
                if (id != null) {
                    IJavaElement j = JavaCore.create((String)id);
                    if (j == null || !j.exists() || !j.isStructureKnown()) {
                        IJavaElement o;
                        IResource resource = marker.getResource();
                        if (MarkerUtilities.getCharStart((IMarker)marker) != -1 && MarkerUtilities.getCharEnd((IMarker)marker) != -1 && resource instanceof IFile && (o = JavaCore.create((IResource)resource)) instanceof ICompilationUnit) {
                            IJavaElement element = ((ICompilationUnit)o).getElementAt(position.getOffset());
                            if (element != null) {
                                marker.setAttribute("org.eclipse.jdt.internal.ui.search.handleID", (Object)element.getHandleIdentifier());
                                marker.setAttribute("org.eclipse.jdt.internal.ui.search.handleIdChanged", (Object)new Boolean(true));
                                return true;
                            }
                            return false;
                        }
                        break block6;
                    }
                    return true;
                }
                return true;
            }
            catch (CoreException ex) {
                ExceptionHandler.handle(ex, SearchMessages.getString("Search.Error.markerAttributeAccess.title"), SearchMessages.getString("Search.Error.markerAttributeAccess.message"));
            }
        }
        return false;
    }

    public String[] getAttribute() {
        return new String[]{"org.eclipse.jdt.internal.ui.search.handleID"};
    }

    public String getMarkerType() {
        return "org.eclipse.search.searchmarker";
    }
}

