/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.refactoring.reorg;

import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.refactoring.reorg.ICreateTargetQuery;
import org.eclipse.jdt.internal.corext.refactoring.reorg.IReorgDestinationValidator;
import org.eclipse.jdt.internal.corext.refactoring.reorg.JavaMoveProcessor;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.jdt.internal.ui.refactoring.reorg.QualifiedNameComponent;
import org.eclipse.jdt.internal.ui.refactoring.reorg.ReorgMessages;
import org.eclipse.jdt.internal.ui.refactoring.reorg.ReorgUserInputPage;
import org.eclipse.jdt.internal.ui.util.SWTUtil;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.MoveRefactoring;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class ReorgMoveWizard
extends RefactoringWizard {
    static /* synthetic */ Class class$org$eclipse$jdt$internal$corext$refactoring$reorg$JavaMoveProcessor;

    public ReorgMoveWizard(MoveRefactoring ref) {
        super((Refactoring)ref, 4 | ReorgMoveWizard.computeHasPreviewPage(ref));
        if (ReorgMoveWizard.isTextualMove(ref)) {
            this.setDefaultPageTitle(ReorgMessages.getString("ReorgMoveWizard.textual_move"));
        } else {
            this.setDefaultPageTitle(ReorgMessages.getString("ReorgMoveWizard.3"));
        }
    }

    private static boolean isTextualMove(MoveRefactoring ref) {
        JavaMoveProcessor moveProcessor = (JavaMoveProcessor)ref.getAdapter(class$org$eclipse$jdt$internal$corext$refactoring$reorg$JavaMoveProcessor == null ? (class$org$eclipse$jdt$internal$corext$refactoring$reorg$JavaMoveProcessor = ReorgMoveWizard.class$("org.eclipse.jdt.internal.corext.refactoring.reorg.JavaMoveProcessor")) : class$org$eclipse$jdt$internal$corext$refactoring$reorg$JavaMoveProcessor);
        return moveProcessor.isTextualMove();
    }

    private static int computeHasPreviewPage(MoveRefactoring refactoring) {
        JavaMoveProcessor processor = (JavaMoveProcessor)refactoring.getAdapter(class$org$eclipse$jdt$internal$corext$refactoring$reorg$JavaMoveProcessor == null ? (class$org$eclipse$jdt$internal$corext$refactoring$reorg$JavaMoveProcessor = ReorgMoveWizard.class$("org.eclipse.jdt.internal.corext.refactoring.reorg.JavaMoveProcessor")) : class$org$eclipse$jdt$internal$corext$refactoring$reorg$JavaMoveProcessor);
        if (processor.canUpdateReferences() || processor.canEnableQualifiedNameUpdating()) {
            return 0;
        }
        return 16;
    }

    protected void addUserInputPages() {
        this.addPage((IWizardPage)new MoveInputPage());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class MoveInputPage
    extends ReorgUserInputPage {
        private static final String PAGE_NAME = "MoveInputPage";
        private Button fReferenceCheckbox;
        private Button fQualifiedNameCheckbox;
        private QualifiedNameComponent fQualifiedNameComponent;
        private Object fDestination;

        public MoveInputPage() {
            super(PAGE_NAME);
        }

        private JavaMoveProcessor getJavaMoveProcessor() {
            return (JavaMoveProcessor)this.getRefactoring().getAdapter(class$org$eclipse$jdt$internal$corext$refactoring$reorg$JavaMoveProcessor == null ? (class$org$eclipse$jdt$internal$corext$refactoring$reorg$JavaMoveProcessor = ReorgMoveWizard.class$("org.eclipse.jdt.internal.corext.refactoring.reorg.JavaMoveProcessor")) : class$org$eclipse$jdt$internal$corext$refactoring$reorg$JavaMoveProcessor);
        }

        protected Object getInitiallySelectedElement() {
            return this.getJavaMoveProcessor().getCommonParentForInputElements();
        }

        protected IJavaElement[] getJavaElements() {
            return this.getJavaMoveProcessor().getJavaElements();
        }

        protected IResource[] getResources() {
            return this.getJavaMoveProcessor().getResources();
        }

        protected IReorgDestinationValidator getDestinationValidator() {
            return this.getJavaMoveProcessor();
        }

        protected boolean performFinish() {
            return super.performFinish() || this.getJavaMoveProcessor().wasCanceled();
        }

        protected RefactoringStatus verifyDestination(Object selected) throws JavaModelException {
            JavaMoveProcessor processor = this.getJavaMoveProcessor();
            RefactoringStatus refactoringStatus = selected instanceof IJavaElement ? processor.setDestination((IJavaElement)selected) : (selected instanceof IResource ? processor.setDestination((IResource)selected) : RefactoringStatus.createFatalErrorStatus((String)ReorgMessages.getString("ReorgMoveWizard.4")));
            this.updateUIStatus();
            this.fDestination = selected;
            return refactoringStatus;
        }

        private void updateUIStatus() {
            this.getRefactoringWizard().setForcePreviewReview(false);
            JavaMoveProcessor processor = this.getJavaMoveProcessor();
            if (this.fReferenceCheckbox != null) {
                this.fReferenceCheckbox.setEnabled(this.canUpdateReferences());
                processor.setUpdateReferences(this.fReferenceCheckbox.getEnabled() && this.fReferenceCheckbox.getSelection());
            }
            if (this.fQualifiedNameCheckbox != null) {
                boolean enabled = processor.canEnableQualifiedNameUpdating();
                this.fQualifiedNameCheckbox.setEnabled(enabled);
                if (enabled) {
                    this.fQualifiedNameComponent.setEnabled(processor.getUpdateQualifiedNames());
                    if (processor.getUpdateQualifiedNames()) {
                        this.getRefactoringWizard().setForcePreviewReview(true);
                    }
                } else {
                    this.fQualifiedNameComponent.setEnabled(false);
                }
                processor.setUpdateQualifiedNames(this.fQualifiedNameCheckbox.getEnabled() && this.fQualifiedNameCheckbox.getSelection());
            }
        }

        private void addUpdateReferenceComponent(Composite result) {
            JavaMoveProcessor processor = this.getJavaMoveProcessor();
            if (!processor.canUpdateReferences()) {
                return;
            }
            this.fReferenceCheckbox = new Button(result, 32);
            this.fReferenceCheckbox.setText(ReorgMessages.getString("JdtMoveAction.update_references"));
            this.fReferenceCheckbox.setSelection(processor.getUpdateReferences());
            this.fReferenceCheckbox.setEnabled(this.canUpdateReferences());
            this.fReferenceCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(this, processor){
                private final /* synthetic */ JavaMoveProcessor val$processor;
                private final /* synthetic */ MoveInputPage this$0;
                {
                    this.this$0 = this$0;
                    this.val$processor = val$processor;
                }

                public void widgetSelected(SelectionEvent e) {
                    this.val$processor.setUpdateReferences(((Button)e.widget).getSelection());
                    MoveInputPage.access$000(this.this$0);
                }
            });
        }

        private void addUpdateQualifiedNameComponent(Composite parent, int marginWidth) {
            JavaMoveProcessor processor = this.getJavaMoveProcessor();
            if (!processor.canEnableQualifiedNameUpdating() || !processor.canUpdateQualifiedNames()) {
                return;
            }
            this.fQualifiedNameCheckbox = new Button(parent, 32);
            int indent = marginWidth + this.fQualifiedNameCheckbox.computeSize((int)-1, (int)-1).x;
            this.fQualifiedNameCheckbox.setText(RefactoringMessages.getString("RenameInputWizardPage.update_qualified_names"));
            this.fQualifiedNameCheckbox.setLayoutData((Object)new GridData(768));
            this.fQualifiedNameCheckbox.setSelection(processor.getUpdateQualifiedNames());
            this.fQualifiedNameComponent = new QualifiedNameComponent(parent, 0, processor, this.getRefactoringSettings());
            this.fQualifiedNameComponent.setLayoutData(new GridData(768));
            GridData gd = (GridData)this.fQualifiedNameComponent.getLayoutData();
            gd.horizontalAlignment = 4;
            gd.horizontalIndent = indent;
            this.updateQualifiedNameUpdating(processor, processor.getUpdateQualifiedNames());
            this.fQualifiedNameCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(this, processor){
                private final /* synthetic */ JavaMoveProcessor val$processor;
                private final /* synthetic */ MoveInputPage this$0;
                {
                    this.this$0 = this$0;
                    this.val$processor = val$processor;
                }

                public void widgetSelected(SelectionEvent e) {
                    boolean enabled = ((Button)e.widget).getSelection();
                    MoveInputPage.access$100(this.this$0, this.val$processor, enabled);
                }
            });
        }

        private void updateQualifiedNameUpdating(JavaMoveProcessor processor, boolean enabled) {
            this.fQualifiedNameComponent.setEnabled(enabled);
            processor.setUpdateQualifiedNames(enabled);
            this.updateUIStatus();
        }

        public void createControl(Composite parent) {
            Composite result;
            boolean showDestinationTree;
            boolean bl = showDestinationTree = !this.getJavaMoveProcessor().hasDestinationSet();
            if (showDestinationTree) {
                super.createControl(parent);
                result = (Composite)super.getControl();
            } else {
                this.initializeDialogUnits((Control)parent);
                result = new Composite(parent, 0);
                this.setControl((Control)result);
                result.setLayout((Layout)new GridLayout());
                Dialog.applyDialogFont((Control)result);
            }
            if (showDestinationTree && this.getJavaMoveProcessor().getCreateTargetQuery() != null) {
                this.addUpdateArea(result);
            } else {
                this.addUpdateReferenceComponent(result);
                this.addUpdateQualifiedNameComponent(result, ((GridLayout)result.getLayout()).marginWidth);
            }
            this.setControl((Control)result);
            Dialog.applyDialogFont((Control)result);
        }

        protected void addUpdateArea(Composite parent) {
            Composite firstLine = new Composite(parent, 0);
            GridLayout layout = new GridLayout(2, false);
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            firstLine.setLayout((Layout)layout);
            firstLine.setLayoutData((Object)new GridData(768));
            if (this.getJavaMoveProcessor().canUpdateReferences()) {
                this.addUpdateReferenceComponent(firstLine);
                this.addUpdateQualifiedNameComponent(parent, layout.marginWidth);
            } else if (this.getJavaMoveProcessor().canUpdateQualifiedNames()) {
                this.addUpdateQualifiedNameComponent(firstLine, layout.marginWidth);
            } else {
                Composite filler = new Composite(firstLine, 0);
                filler.setLayoutData((Object)new GridData(1808));
            }
            Button newButton = new Button(firstLine, 8);
            newButton.setText(ReorgMessages.getString("ReorgMoveWizard.new"));
            GridData gd = new GridData(642);
            gd.heightHint = SWTUtil.getButtonHeightHint(newButton);
            gd.widthHint = SWTUtil.getButtonWidthHint(newButton);
            newButton.setLayoutData((Object)gd);
            newButton.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                private final /* synthetic */ MoveInputPage this$0;
                {
                    this.this$0 = this$0;
                }

                public void widgetSelected(SelectionEvent e) {
                    MoveInputPage.access$200(this.this$0);
                }
            });
        }

        private boolean canUpdateReferences() {
            return this.getJavaMoveProcessor().canUpdateReferences();
        }

        private void doNewButtonPressed() {
            ICreateTargetQuery createTargetQuery = this.getJavaMoveProcessor().getCreateTargetQuery();
            Object newElement = createTargetQuery.getCreatedTarget(this.fDestination);
            if (newElement != null) {
                this.addElementToTree(newElement);
            }
        }

        static /* synthetic */ void access$000(MoveInputPage x0) {
            x0.updateUIStatus();
        }

        static /* synthetic */ void access$100(MoveInputPage x0, JavaMoveProcessor x1, boolean x2) {
            x0.updateQualifiedNameUpdating(x1, x2);
        }

        static /* synthetic */ void access$200(MoveInputPage x0) {
            x0.doNewButtonPressed();
        }
    }
}

