/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.refactoring.nls;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.refactoring.nls.KeyValuePair;
import org.eclipse.jdt.internal.corext.refactoring.nls.NLSRefactoring;
import org.eclipse.jdt.internal.corext.refactoring.nls.NLSSubstitution;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.dialogs.StatusDialog;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.internal.ui.javaeditor.JavaSourceViewer;
import org.eclipse.jdt.internal.ui.refactoring.nls.MultiStateCellEditor;
import org.eclipse.jdt.internal.ui.refactoring.nls.NLSAccessorConfigurationDialog;
import org.eclipse.jdt.internal.ui.refactoring.nls.NLSUIMessages;
import org.eclipse.jdt.internal.ui.refactoring.nls.RenameKeysDialog;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.internal.ui.util.SWTUtil;
import org.eclipse.jdt.internal.ui.viewsupport.JavaElementImageProvider;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.StringDialogField;
import org.eclipse.jdt.ui.JavaElementImageDescriptor;
import org.eclipse.jdt.ui.text.JavaSourceViewerConfiguration;
import org.eclipse.jdt.ui.text.JavaTextTools;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.FontRegistry;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.ui.refactoring.UserInputWizardPage;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.help.WorkbenchHelp;

class ExternalizeWizardPage
extends UserInputWizardPage {
    private static final String[] PROPERTIES = new String[3];
    private static final String[] fgTitles;
    private static final int STATE_PROP = 0;
    private static final int VAL_PROP = 1;
    private static final int KEY_PROP = 2;
    private static final int SIZE = 3;
    private static final int ROW_COUNT = 5;
    public static final String PAGE_NAME = "NLSWizardPage1";
    private Text fPrefixField;
    private Table fTable;
    private TableViewer fTableViewer;
    private SourceViewer fSourceViewer;
    private final ICompilationUnit fCu;
    private NLSSubstitution[] fSubstitutions;
    private Button fExternalizeButton;
    private Button fIgnoreButton;
    private Button fInternalizeButton;
    private Button fRevertButton;
    private Button fEditButton;
    private NLSRefactoring fNLSRefactoring;
    private Button fRenameButton;
    private Text fAccessorClassField;
    private Text fPropertiesFileField;
    private Button fFilterCheckBox;

    public ExternalizeWizardPage(NLSRefactoring nlsRefactoring) {
        super(PAGE_NAME);
        this.fCu = nlsRefactoring.getCu();
        this.fSubstitutions = nlsRefactoring.getSubstitutions();
        this.fNLSRefactoring = nlsRefactoring;
        this.createDefaultExternalization(this.fSubstitutions, nlsRefactoring.getPrefix());
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite supercomposite = new Composite(parent, 0);
        supercomposite.setLayout((Layout)new GridLayout());
        this.createKeyPrefixField(supercomposite);
        SashForm composite = new SashForm(supercomposite, 512);
        GridData data = new GridData(1808);
        composite.setLayoutData((Object)data);
        this.createTableViewer((Composite)composite);
        this.createSourceViewer((Composite)composite);
        this.createAccessorInfoComposite(supercomposite);
        composite.setWeights(new int[]{65, 45});
        this.validateKeys();
        this.setControl((Control)supercomposite);
        Dialog.applyDialogFont((Control)supercomposite);
        WorkbenchHelp.setHelp((Control)supercomposite, (String)"org.eclipse.jdt.ui.externalize_wizard_keyvalue_page_context");
    }

    private void createAccessorInfoComposite(Composite supercomposite) {
        Composite accessorComposite = new Composite(supercomposite, 0);
        accessorComposite.setLayoutData((Object)new GridData(768));
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        accessorComposite.setLayout((Layout)layout);
        Composite composite = new Composite(accessorComposite, 0);
        composite.setLayoutData((Object)new GridData(768));
        layout = new GridLayout(2, true);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        Label accessorClassLabel = new Label(composite, 0);
        accessorClassLabel.setText(NLSUIMessages.getString("ExternalizeWizardPage.accessorclass.label"));
        accessorClassLabel.setLayoutData((Object)new GridData());
        Label propertiesFileLabel = new Label(composite, 0);
        propertiesFileLabel.setText(NLSUIMessages.getString("ExternalizeWizardPage.propertiesfile.label"));
        propertiesFileLabel.setLayoutData((Object)new GridData());
        GridData data = new GridData(768);
        data.widthHint = this.convertWidthInCharsToPixels(30);
        this.fAccessorClassField = new Text(composite, 2052);
        this.fAccessorClassField.setLayoutData((Object)data);
        this.fAccessorClassField.setEditable(false);
        data = new GridData(768);
        data.widthHint = this.convertWidthInCharsToPixels(30);
        this.fPropertiesFileField = new Text(composite, 2052);
        this.fPropertiesFileField.setLayoutData((Object)data);
        this.fPropertiesFileField.setEditable(false);
        Button configure = new Button(accessorComposite, 8);
        configure.setText(NLSUIMessages.getString("ExternalizeWizardPage.configure.button"));
        data = new GridData(136);
        data.widthHint = SWTUtil.getButtonWidthHint(configure);
        data.heightHint = SWTUtil.getButtonHeightHint(configure);
        configure.setLayoutData((Object)data);
        configure.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ExternalizeWizardPage.this.doConfigureButtonPressed();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.updateAccessorFieldLabels();
    }

    private void updateAccessorFieldLabels() {
        String accessorClass = JavaModelUtil.concatenateName(this.fNLSRefactoring.getAccessorClassPackage().getElementName(), this.fNLSRefactoring.getAccessorClassName());
        this.fAccessorClassField.setText(accessorClass);
        this.fPropertiesFileField.setText(this.fNLSRefactoring.getPropertyFilePath().makeRelative().toString());
    }

    private void doConfigureButtonPressed() {
        NLSAccessorConfigurationDialog dialog = new NLSAccessorConfigurationDialog(this.getShell(), this.fNLSRefactoring);
        if (dialog.open() == 0) {
            NLSSubstitution.updateSubtitutions(this.fSubstitutions, this.getProperties(this.fNLSRefactoring.getPropertyFileHandle()), this.fNLSRefactoring.getAccessorClassName());
            this.fTableViewer.refresh(true);
            this.updateAccessorFieldLabels();
        }
    }

    private Properties getProperties(IFile propertyFile) {
        Properties props = new Properties();
        try {
            if (propertyFile.exists()) {
                InputStream is = propertyFile.getContents();
                props.load(is);
                is.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return props;
    }

    private void createTableViewer(Composite composite) {
        this.createTableComposite(composite);
        this.fTableViewer = new TableViewer(this.fTable){

            protected void hookControl(Control control) {
                super.hookControl(control);
                ((Table)control).addMouseListener((MouseListener)new MouseAdapter(this){
                    private final /* synthetic */ 2 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void mouseDoubleClick(MouseEvent e) {
                        if (this.this$1.getTable().getSelection().length == 0) {
                            return;
                        }
                        TableItem item = this.this$1.getTable().getSelection()[0];
                        if (item.getBounds(0).contains(e.x, e.y)) {
                            List widgetSel = 2.access$500(this.this$1);
                            if (widgetSel == null || widgetSel.size() != 1) {
                                return;
                            }
                            NLSSubstitution substitution = (NLSSubstitution)widgetSel.get(0);
                            Integer value = (Integer)this.this$1.getCellModifier().getValue((Object)substitution, ExternalizeWizardPage.access$000()[0]);
                            int newValue = MultiStateCellEditor.getNextValue(3, value);
                            this.this$1.getCellModifier().modify((Object)item, ExternalizeWizardPage.access$000()[0], (Object)new Integer(newValue));
                        }
                    }
                });
            }

            static /* synthetic */ List access$500(2 x0) {
                return x0.getSelectionFromWidget();
            }
        };
        this.fTableViewer.setUseHashlookup(true);
        CellEditor[] editors = this.createCellEditors();
        this.fTableViewer.setCellEditors(editors);
        this.fTableViewer.setColumnProperties(PROPERTIES);
        this.fTableViewer.setCellModifier((ICellModifier)new CellModifier());
        this.fTableViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                return ExternalizeWizardPage.this.fSubstitutions;
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.fTableViewer.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (!ExternalizeWizardPage.this.fFilterCheckBox.getSelection()) {
                    return true;
                }
                NLSSubstitution curr = (NLSSubstitution)element;
                return curr.getInitialState() == 2 || curr.getInitialState() == 0 && curr.getInitialValue() == null;
            }
        });
        this.fTableViewer.setLabelProvider((IBaseLabelProvider)new NLSSubstitutionLabelProvider());
        this.fTableViewer.setInput(new Object());
        this.fTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ExternalizeWizardPage.this.selectionChanged(event);
            }
        });
    }

    private void createDefaultExternalization(NLSSubstitution[] substitutions, String defaultPrefix) {
        for (int i = 0; i < substitutions.length; ++i) {
            NLSSubstitution substitution = substitutions[i];
            if (substitution.getState() != 2) continue;
            substitution.setState(0);
            substitution.generateKey(substitutions);
        }
    }

    private CellEditor[] createCellEditors() {
        CellEditor[] editors = new CellEditor[3];
        editors[0] = new MultiStateCellEditor((Composite)this.fTable, 3, 0);
        editors[2] = new TextCellEditor((Composite)this.fTable);
        editors[1] = new TextCellEditor((Composite)this.fTable);
        return editors;
    }

    private void createSourceViewer(Composite parent) {
        Composite c = new Composite(parent, 0);
        c.setLayoutData((Object)new GridData(1808));
        GridLayout gl = new GridLayout();
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        c.setLayout((Layout)gl);
        Label l = new Label(c, 0);
        l.setText(NLSUIMessages.getString("ExternalizeWizardPage.context"));
        l.setLayoutData((Object)new GridData());
        JavaTextTools tools = JavaPlugin.getDefault().getJavaTextTools();
        int styles = 68354;
        IPreferenceStore store = JavaPlugin.getDefault().getCombinedPreferenceStore();
        this.fSourceViewer = new JavaSourceViewer(c, null, null, false, styles, store);
        this.fSourceViewer.configure((SourceViewerConfiguration)new JavaSourceViewerConfiguration(tools.getColorManager(), store, null, null));
        this.fSourceViewer.getControl().setFont(JFaceResources.getFont((String)"org.eclipse.jdt.ui.editors.textfont"));
        try {
            String contents = this.fCu.getBuffer().getContents();
            Document document = new Document(contents);
            tools.setupJavaDocumentPartitioner((IDocument)document);
            this.fSourceViewer.setDocument((IDocument)document);
            this.fSourceViewer.setEditable(false);
            GridData gd = new GridData(1808);
            gd.heightHint = this.convertHeightInCharsToPixels(10);
            gd.widthHint = this.convertWidthInCharsToPixels(40);
            this.fSourceViewer.getControl().setLayoutData((Object)gd);
        }
        catch (JavaModelException e) {
            ExceptionHandler.handle((CoreException)((Object)e), NLSUIMessages.getString("ExternalizeWizardPage.title"), NLSUIMessages.getString("ExternalizeWizardPage.exception"));
        }
    }

    private void createKeyPrefixField(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(768));
        GridLayout gl = new GridLayout();
        gl.numColumns = 2;
        gl.marginWidth = 0;
        composite.setLayout((Layout)gl);
        Label l = new Label(composite, 0);
        l.setText(NLSUIMessages.getString("ExternalizeWizardPage.common_prefix"));
        l.setLayoutData((Object)new GridData());
        this.fPrefixField = new Text(composite, 2052);
        this.fPrefixField.setLayoutData((Object)new GridData(768));
        this.fPrefixField.setText(this.fNLSRefactoring.getPrefix());
        this.fPrefixField.selectAll();
        this.fPrefixField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ExternalizeWizardPage.this.fNLSRefactoring.setPrefix(ExternalizeWizardPage.this.fPrefixField.getText());
                ExternalizeWizardPage.this.fTableViewer.refresh(true);
            }
        });
    }

    private void validateKeys() {
        RefactoringStatus status = new RefactoringStatus();
        this.checkDuplicateKeys(status);
        this.checkMissingKeys(status);
        this.setPageComplete(status);
    }

    private void checkDuplicateKeys(RefactoringStatus status) {
        for (int i = 0; i < this.fSubstitutions.length; ++i) {
            NLSSubstitution substitution = this.fSubstitutions[i];
            if (!this.conflictingKeys(substitution)) continue;
            status.addFatalError(NLSUIMessages.getString("ExternalizeWizardPage.warning.conflicting"));
            return;
        }
    }

    private void checkMissingKeys(RefactoringStatus status) {
        for (int i = 0; i < this.fSubstitutions.length; ++i) {
            NLSSubstitution substitution = this.fSubstitutions[i];
            if (substitution.getValue() != null || substitution.getKey() == null) continue;
            status.addWarning(NLSUIMessages.getString("ExternalizeWizardPage.warning.keymissing"));
            return;
        }
    }

    private boolean conflictingKeys(NLSSubstitution substitution) {
        if (substitution.getState() == 0) {
            return substitution.isConflicting(this.fSubstitutions);
        }
        return false;
    }

    private void createTableComposite(Composite parent) {
        Composite comp = new Composite(parent, 0);
        comp.setLayoutData((Object)new GridData(1808));
        GridLayout gl = new GridLayout();
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        comp.setLayout((Layout)gl);
        Composite labelComp = new Composite(comp, 0);
        gl = new GridLayout();
        gl.numColumns = 2;
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        labelComp.setLayout((Layout)gl);
        labelComp.setLayoutData((Object)new GridData(256));
        Label l = new Label(labelComp, 0);
        l.setText(NLSUIMessages.getString("ExternalizeWizardPage.strings_to_externalize"));
        l.setLayoutData((Object)new GridData(768));
        this.fFilterCheckBox = new Button(labelComp, 32);
        this.fFilterCheckBox.setText(NLSUIMessages.getString("ExternalizeWizardPage.filter.label"));
        this.fFilterCheckBox.setLayoutData((Object)new GridData(128));
        this.fFilterCheckBox.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ExternalizeWizardPage.this.doFilterCheckBoxPressed();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.fFilterCheckBox.setSelection(this.hasNewOrMissingSubstitutions());
        Control tableControl = this.createTable(comp);
        tableControl.setLayoutData((Object)new GridData(1808));
    }

    private boolean hasNewOrMissingSubstitutions() {
        for (int i = 0; i < this.fSubstitutions.length; ++i) {
            NLSSubstitution curr = this.fSubstitutions[i];
            if (curr.getInitialState() == 2) {
                return true;
            }
            if (curr.getInitialState() != 0 || curr.getInitialValue() != null) continue;
            return true;
        }
        return false;
    }

    protected void doFilterCheckBoxPressed() {
        this.fTableViewer.refresh();
    }

    private Control createTable(Composite parent) {
        Composite c = new Composite(parent, 0);
        GridLayout gl = new GridLayout();
        gl.numColumns = 2;
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        c.setLayout((Layout)gl);
        this.fTable = new Table(c, 101122);
        GridData tableGD = new GridData(1808);
        tableGD.heightHint = SWTUtil.getTableHeightHint(this.fTable, 5);
        this.fTable.setLayoutData((Object)tableGD);
        this.fTable.setLinesVisible(true);
        TableLayout layout = new TableLayout();
        this.fTable.setLayout((Layout)layout);
        this.fTable.setHeaderVisible(true);
        ColumnLayoutData[] columnLayoutData = new ColumnLayoutData[3];
        columnLayoutData[0] = new ColumnPixelData(20, false);
        columnLayoutData[2] = new ColumnWeightData(40, true);
        columnLayoutData[1] = new ColumnWeightData(40, true);
        for (int i = 0; i < fgTitles.length; ++i) {
            TableColumn tc = new TableColumn(this.fTable, 0, i);
            tc.setText(fgTitles[i]);
            layout.addColumnData(columnLayoutData[i]);
            tc.setResizable(columnLayoutData[i].resizable);
        }
        this.createButtonComposite(c);
        return c;
    }

    private void createButtonComposite(Composite parent) {
        Composite buttonComp = new Composite(parent, 0);
        GridLayout gl = new GridLayout();
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        buttonComp.setLayout((Layout)gl);
        buttonComp.setLayoutData((Object)new GridData(1040));
        SelectionAdapter adapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExternalizeWizardPage.this.handleButtonPressed(e.widget);
            }
        };
        this.fExternalizeButton = this.createTaskButton(buttonComp, NLSUIMessages.getString("ExternalizeWizardPage.Externalize_Selected"), adapter);
        this.fIgnoreButton = this.createTaskButton(buttonComp, NLSUIMessages.getString("ExternalizeWizardPage.Ignore_Selected"), adapter);
        this.fInternalizeButton = this.createTaskButton(buttonComp, NLSUIMessages.getString("ExternalizeWizardPage.Internalize_Selected"), adapter);
        new Label(buttonComp, 0);
        this.fEditButton = this.createTaskButton(buttonComp, NLSUIMessages.getString("ExternalizeWizardPage.Edit_key_and_value"), adapter);
        this.fRevertButton = this.createTaskButton(buttonComp, NLSUIMessages.getString("ExternalizeWizardPage.Revert_Selected"), adapter);
        this.fRenameButton = this.createTaskButton(buttonComp, NLSUIMessages.getString("ExternalizeWizardPage.Rename_Keys"), adapter);
        this.fEditButton.setEnabled(false);
        this.fRenameButton.setEnabled(false);
        buttonComp.pack();
    }

    protected void handleButtonPressed(Widget widget) {
        if (widget == this.fExternalizeButton) {
            this.setSelectedTasks(0);
        } else if (widget == this.fIgnoreButton) {
            this.setSelectedTasks(1);
        } else if (widget == this.fInternalizeButton) {
            this.setSelectedTasks(2);
        } else if (widget == this.fEditButton) {
            this.openEditButton(this.fTableViewer.getSelection());
        } else if (widget == this.fRevertButton) {
            this.revertStateOfSelection();
        } else if (widget == this.fRenameButton) {
            this.openRenameDialog();
        }
    }

    private void openRenameDialog() {
        IStructuredSelection sel = (IStructuredSelection)this.fTableViewer.getSelection();
        List elementsToRename = this.getExternalizedElements(sel);
        RenameKeysDialog dialog = new RenameKeysDialog(this.getShell(), elementsToRename);
        if (dialog.open() == 0) {
            this.fTableViewer.refresh();
            this.updateButtonStates((IStructuredSelection)this.fTableViewer.getSelection());
        }
    }

    private void revertStateOfSelection() {
        List selection = this.getSelectedTableEntries();
        Iterator iter = selection.iterator();
        while (iter.hasNext()) {
            NLSSubstitution substitution = (NLSSubstitution)iter.next();
            substitution.revert();
        }
        this.fTableViewer.refresh();
        this.updateButtonStates((IStructuredSelection)this.fTableViewer.getSelection());
    }

    private Button createTaskButton(Composite parent, String label, SelectionAdapter adapter) {
        Button button = new Button(parent, 8);
        button.setText(label);
        button.setLayoutData((Object)new GridData(768));
        SWTUtil.setButtonDimensionHint(button);
        button.addSelectionListener((SelectionListener)adapter);
        return button;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void openEditButton(ISelection selection) {
        block7: {
            block6: {
                block5: {
                    try {
                        IStructuredSelection sel = (IStructuredSelection)this.fTableViewer.getSelection();
                        NLSSubstitution substitution = (NLSSubstitution)sel.getFirstElement();
                        if (substitution == null) {
                            Object var7_4 = null;
                            break block5;
                        }
                        NLSInputDialog dialog = new NLSInputDialog(this.getShell(), substitution);
                        if (dialog.open() == 1) {
                            break block6;
                        }
                        KeyValuePair kvPair = dialog.getResult();
                        if (substitution.getState() == 0) {
                            substitution.setKey(kvPair.getKey());
                        }
                        substitution.setValue(kvPair.getValue());
                        this.validateKeys();
                        break block7;
                    }
                    catch (Throwable throwable) {
                        Object var7_7 = null;
                        this.fTableViewer.refresh();
                        this.fTableViewer.getControl().setFocus();
                        this.fTableViewer.setSelection(selection);
                        throw throwable;
                    }
                }
                this.fTableViewer.refresh();
                this.fTableViewer.getControl().setFocus();
                this.fTableViewer.setSelection(selection);
                return;
            }
            Object var7_5 = null;
            this.fTableViewer.refresh();
            this.fTableViewer.getControl().setFocus();
            this.fTableViewer.setSelection(selection);
            return;
        }
        Object var7_6 = null;
        this.fTableViewer.refresh();
        this.fTableViewer.getControl().setFocus();
        this.fTableViewer.setSelection(selection);
    }

    private List getSelectedTableEntries() {
        ISelection sel = this.fTableViewer.getSelection();
        if (sel instanceof IStructuredSelection) {
            return ((IStructuredSelection)sel).toList();
        }
        return Collections.EMPTY_LIST;
    }

    private void setSelectedTasks(int state) {
        Assert.isTrue(state == 0 || state == 1 || state == 2);
        List selected = this.getSelectedTableEntries();
        String[] props = new String[]{PROPERTIES[0]};
        Iterator iter = selected.iterator();
        while (iter.hasNext()) {
            NLSSubstitution substitution = (NLSSubstitution)iter.next();
            substitution.setState(state);
            if (substitution.getState() != 0 || !substitution.hasStateChanged()) continue;
            substitution.generateKey(this.fSubstitutions);
        }
        this.fTableViewer.update(selected.toArray(), props);
        this.fTableViewer.getControl().setFocus();
        this.updateButtonStates((IStructuredSelection)this.fTableViewer.getSelection());
    }

    private void selectionChanged(SelectionChangedEvent event) {
        IStructuredSelection selection = (IStructuredSelection)event.getSelection();
        this.updateButtonStates(selection);
        this.updateSourceView(selection);
    }

    private void updateSourceView(IStructuredSelection selection) {
        NLSSubstitution first = (NLSSubstitution)selection.getFirstElement();
        if (first != null) {
            Region region = first.getNLSElement().getPosition();
            this.fSourceViewer.setSelectedRange(region.getOffset(), region.getLength());
            this.fSourceViewer.revealRange(region.getOffset(), region.getLength());
        }
    }

    private void updateButtonStates(IStructuredSelection selection) {
        this.fExternalizeButton.setEnabled(true);
        this.fIgnoreButton.setEnabled(true);
        this.fInternalizeButton.setEnabled(true);
        this.fRevertButton.setEnabled(true);
        if (this.containsOnlyElementsOfSameState(0, selection)) {
            this.fExternalizeButton.setEnabled(false);
        }
        if (this.containsOnlyElementsOfSameState(1, selection)) {
            this.fIgnoreButton.setEnabled(false);
        }
        if (this.containsOnlyElementsOfSameState(2, selection)) {
            this.fInternalizeButton.setEnabled(false);
        }
        if (!this.containsElementsWithChange(selection)) {
            this.fRevertButton.setEnabled(false);
        }
        this.fRenameButton.setEnabled(this.getExternalizedElements(selection).size() > 1);
        this.fEditButton.setEnabled(selection.size() == 1);
    }

    private boolean containsElementsWithChange(IStructuredSelection selection) {
        Iterator iter = selection.iterator();
        while (iter.hasNext()) {
            NLSSubstitution substitution = (NLSSubstitution)iter.next();
            if (!substitution.hasPropertyFileChange() && !substitution.hasSourceChange()) continue;
            return true;
        }
        return false;
    }

    private List getExternalizedElements(IStructuredSelection selection) {
        ArrayList<NLSSubstitution> res = new ArrayList<NLSSubstitution>();
        Iterator iter = selection.iterator();
        while (iter.hasNext()) {
            NLSSubstitution substitution = (NLSSubstitution)iter.next();
            if (substitution.getState() != 0 || substitution.hasStateChanged()) continue;
            res.add(substitution);
        }
        return res;
    }

    private boolean containsOnlyElementsOfSameState(int state, IStructuredSelection selection) {
        Iterator iter = selection.iterator();
        while (iter.hasNext()) {
            NLSSubstitution substitution = (NLSSubstitution)iter.next();
            if (substitution.getState() == state) continue;
            return false;
        }
        return true;
    }

    public boolean performFinish() {
        return super.performFinish();
    }

    public IWizardPage getNextPage() {
        return super.getNextPage();
    }

    public void dispose() {
        this.fPrefixField = null;
        this.fSourceViewer = null;
        this.fTable = null;
        this.fTableViewer = null;
        this.fEditButton = null;
        super.dispose();
    }

    static {
        ExternalizeWizardPage.PROPERTIES[0] = "task";
        ExternalizeWizardPage.PROPERTIES[2] = "key";
        ExternalizeWizardPage.PROPERTIES[1] = "value";
        fgTitles = new String[3];
        ExternalizeWizardPage.fgTitles[0] = "";
        ExternalizeWizardPage.fgTitles[2] = NLSUIMessages.getString("ExternalizeWizardPage.key");
        ExternalizeWizardPage.fgTitles[1] = NLSUIMessages.getString("ExternalizeWizardPage.value");
    }

    private class NLSInputDialog
    extends StatusDialog
    implements IDialogFieldListener {
        private StringDialogField fKeyField;
        private StringDialogField fValueField;
        private DialogField fMessageField;
        private NLSSubstitution fSubstitution;

        public NLSInputDialog(Shell parent, NLSSubstitution substitution) {
            super(parent);
            this.setTitle(NLSUIMessages.getString("ExternalizeWizardPage.NLSInputDialog.Title"));
            this.fSubstitution = substitution;
            this.fMessageField = new DialogField();
            if (substitution.getState() == 0) {
                this.fMessageField.setLabelText(NLSUIMessages.getString("ExternalizeWizardPage.NLSInputDialog.ext.Label"));
            } else {
                this.fMessageField.setLabelText(NLSUIMessages.getString("ExternalizeWizardPage.NLSInputDialog.Label"));
            }
            this.fKeyField = new StringDialogField();
            this.fKeyField.setLabelText(NLSUIMessages.getString("ExternalizeWizardPage.NLSInputDialog.Enter_key"));
            this.fKeyField.setDialogFieldListener(this);
            this.fValueField = new StringDialogField();
            this.fValueField.setLabelText(NLSUIMessages.getString("ExternalizeWizardPage.NLSInputDialog.Enter_value"));
            this.fValueField.setDialogFieldListener(this);
            if (substitution.getState() == 0) {
                this.fKeyField.setText(substitution.getKeyWithoutPrefix());
            } else {
                this.fKeyField.setText("");
            }
            this.fValueField.setText(substitution.getValueNonEmpty());
        }

        public KeyValuePair getResult() {
            KeyValuePair res = new KeyValuePair(this.fKeyField.getText(), this.fValueField.getText());
            return res;
        }

        protected Control createDialogArea(Composite parent) {
            Composite composite = (Composite)super.createDialogArea(parent);
            Composite inner = new Composite(composite, 0);
            GridLayout layout = new GridLayout();
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            layout.numColumns = 2;
            inner.setLayout((Layout)layout);
            this.fMessageField.doFillIntoGrid(inner, 2);
            if (this.fSubstitution.getState() == 0) {
                this.fKeyField.doFillIntoGrid(inner, 2);
                LayoutUtil.setWidthHint((Control)this.fKeyField.getTextControl(null), this.convertWidthInCharsToPixels(45));
            }
            this.fValueField.doFillIntoGrid(inner, 2);
            LayoutUtil.setWidthHint((Control)this.fValueField.getTextControl(null), this.convertWidthInCharsToPixels(45));
            LayoutUtil.setHorizontalGrabbing((Control)this.fValueField.getTextControl(null));
            this.fValueField.postSetFocusOnDialogField(parent.getDisplay());
            NLSInputDialog.applyDialogFont((Control)composite);
            return composite;
        }

        public void dialogFieldChanged(DialogField field) {
            IStatus keyStatus = this.validateKey(this.fKeyField.getText());
            this.updateStatus(keyStatus);
        }

        private IStatus validateKey(String val) {
            if (this.fSubstitution.getState() != 0) {
                return StatusInfo.OK_STATUS;
            }
            if (val.length() == 0) {
                return new StatusInfo(4, NLSUIMessages.getString("ExternalizeWizardPage.NLSInputDialog.Error_empty_key"));
            }
            for (int i = 0; i < val.length(); ++i) {
                if (!Character.isWhitespace(val.charAt(i))) continue;
                return new StatusInfo(4, NLSUIMessages.getString("ExternalizeWizardPage.NLSInputDialog.Error_invalid_key"));
            }
            return StatusInfo.OK_STATUS;
        }
    }

    private class NLSSubstitutionLabelProvider
    extends LabelProvider
    implements ITableLabelProvider,
    IFontProvider {
        private Font fBold;

        public NLSSubstitutionLabelProvider() {
            FontRegistry fontRegistry = PlatformUI.getWorkbench().getThemeManager().getCurrentTheme().getFontRegistry();
            this.fBold = fontRegistry.getBold("org.eclipse.jface.dialogfont");
        }

        public String getColumnText(Object element, int columnIndex) {
            String columnText = "";
            if (element instanceof NLSSubstitution) {
                NLSSubstitution substitution = (NLSSubstitution)element;
                if (columnIndex == 2) {
                    if (substitution.getState() == 0) {
                        columnText = substitution.getKey();
                    }
                } else if (columnIndex == 1 && substitution.getValue() != null) {
                    columnText = substitution.getValue();
                }
            }
            return this.unwindEscapeChars(columnText);
        }

        private String unwindEscapeChars(String s) {
            if (s != null) {
                StringBuffer sb = new StringBuffer(s.length());
                int length = s.length();
                for (int i = 0; i < length; ++i) {
                    char c = s.charAt(i);
                    sb.append(this.getUnwoundString(c));
                }
                return sb.toString();
            }
            return null;
        }

        private String getUnwoundString(char c) {
            switch (c) {
                case '\b': {
                    return "\\b";
                }
                case '\t': {
                    return "\\t";
                }
                case '\n': {
                    return "\\n";
                }
                case '\f': {
                    return "\\f";
                }
                case '\r': {
                    return "\\r";
                }
                case '\\': {
                    return "\\\\";
                }
            }
            return String.valueOf(c);
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (columnIndex == 0 && element instanceof NLSSubstitution) {
                return this.getNLSImage((NLSSubstitution)element);
            }
            return null;
        }

        public Font getFont(Object element) {
            NLSSubstitution substitution;
            if (element instanceof NLSSubstitution && ((substitution = (NLSSubstitution)element).hasPropertyFileChange() || substitution.hasSourceChange())) {
                return this.fBold;
            }
            return null;
        }

        private Image getNLSImage(NLSSubstitution sub) {
            if (sub.getValue() == null && sub.getKey() != null) {
                JavaElementImageDescriptor imageDescriptor = new JavaElementImageDescriptor(this.getNLSImageDescriptor(sub.getState()), 64, JavaElementImageProvider.SMALL_SIZE);
                return JavaPlugin.getImageDescriptorRegistry().get((ImageDescriptor)imageDescriptor);
            }
            if (sub.isConflicting(ExternalizeWizardPage.this.fSubstitutions)) {
                JavaElementImageDescriptor imageDescriptor = new JavaElementImageDescriptor(this.getNLSImageDescriptor(sub.getState()), 64, JavaElementImageProvider.SMALL_SIZE);
                return JavaPlugin.getImageDescriptorRegistry().get((ImageDescriptor)imageDescriptor);
            }
            return this.getNLSImage(sub.getState());
        }

        private Image getNLSImage(int task) {
            switch (task) {
                case 0: {
                    return JavaPluginImages.get("org.eclipse.jdt.ui.translate.gif");
                }
                case 1: {
                    return JavaPluginImages.get("org.eclipse.jdt.ui.never_translate.gif");
                }
                case 2: {
                    return JavaPluginImages.get("org.eclipse.jdt.ui.skip.gif");
                }
            }
            Assert.isTrue(false);
            return null;
        }

        private ImageDescriptor getNLSImageDescriptor(int task) {
            switch (task) {
                case 0: {
                    return JavaPluginImages.DESC_OBJS_NLS_TRANSLATE;
                }
                case 1: {
                    return JavaPluginImages.DESC_OBJS_NLS_NEVER_TRANSLATE;
                }
                case 2: {
                    return JavaPluginImages.DESC_OBJS_NLS_SKIP;
                }
            }
            Assert.isTrue(false);
            return null;
        }
    }

    private class CellModifier
    implements ICellModifier {
        private CellModifier() {
        }

        public boolean canModify(Object element, String property) {
            if (property == null) {
                return false;
            }
            if (!(element instanceof NLSSubstitution)) {
                return false;
            }
            NLSSubstitution subst = (NLSSubstitution)element;
            return !PROPERTIES[2].equals(property) || subst.getState() == 0;
        }

        public Object getValue(Object element, String property) {
            if (element instanceof NLSSubstitution) {
                NLSSubstitution substitution = (NLSSubstitution)element;
                String res = null;
                if (PROPERTIES[2].equals(property)) {
                    res = substitution.getKeyWithoutPrefix();
                } else if (PROPERTIES[1].equals(property)) {
                    res = substitution.getValue();
                } else if (PROPERTIES[0].equals(property)) {
                    return new Integer(substitution.getState());
                }
                if (res != null) {
                    return res;
                }
                return "";
            }
            return "";
        }

        public void modify(Object element, String property, Object value) {
            if (element instanceof TableItem) {
                Object data = ((TableItem)element).getData();
                if (data instanceof NLSSubstitution) {
                    NLSSubstitution substitution = (NLSSubstitution)data;
                    if (PROPERTIES[2].equals(property)) {
                        substitution.setKey((String)value);
                        ExternalizeWizardPage.this.validateKeys();
                    }
                    if (PROPERTIES[1].equals(property)) {
                        substitution.setValue((String)value);
                        ExternalizeWizardPage.this.validateKeys();
                    }
                    if (PROPERTIES[0].equals(property)) {
                        substitution.setState((Integer)value);
                        if (substitution.getState() == 0 && substitution.hasStateChanged()) {
                            substitution.generateKey(ExternalizeWizardPage.this.fSubstitutions);
                        }
                    }
                }
                ExternalizeWizardPage.this.fTableViewer.refresh();
            }
        }
    }
}

