/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.launcher;

import org.eclipse.debug.internal.ui.stringsubstitution.StringVariableSelectionDialog;
import org.eclipse.jdt.debug.ui.IJavaDebugUIConstants;
import org.eclipse.jdt.internal.debug.ui.DialogSettingsHelper;
import org.eclipse.jdt.internal.debug.ui.actions.RuntimeClasspathAction;
import org.eclipse.jdt.internal.debug.ui.launcher.IClasspathViewer;
import org.eclipse.jdt.internal.debug.ui.launcher.LauncherMessages;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class RuntimeClasspathAdvancedDialog
extends Dialog {
    private IAction[] fActions;
    private Button[] fButtons;
    private IClasspathViewer fViewer;
    private Button fAddVariableStringButton;
    private Text fVariableString;

    public RuntimeClasspathAdvancedDialog(Shell parentShell, IAction[] actions, IClasspathViewer viewer) {
        super(parentShell);
        this.setShellStyle(0x10 | this.getShellStyle());
        this.fActions = actions;
        this.fViewer = viewer;
    }

    protected Control createDialogArea(Composite parent) {
        Composite inner = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        inner.setLayout((Layout)layout);
        GridData gd = new GridData(1808);
        inner.setLayoutData((Object)gd);
        Label l = new Label(inner, 0);
        l.setText(LauncherMessages.getString("RuntimeClasspathAdvancedDialog.Select_an_advanced_option__1"));
        gd = new GridData(768);
        l.setLayoutData((Object)gd);
        this.fButtons = new Button[this.fActions.length];
        for (int i = 0; i < this.fActions.length; ++i) {
            IAction action = this.fActions[i];
            this.fButtons[i] = new Button(inner, 16);
            this.fButtons[i].setText(action.getText());
            this.fButtons[i].setData((Object)action);
            this.fButtons[i].setEnabled(action.isEnabled());
            this.fButtons[i].setLayoutData((Object)new GridData(768));
        }
        this.addVariableStringComposite(inner);
        this.getShell().setText(LauncherMessages.getString("RuntimeClasspathAdvancedDialog.Advanced_Options_1"));
        Dialog.applyDialogFont((Control)parent);
        return inner;
    }

    private void addVariableStringComposite(Composite composite) {
        this.fAddVariableStringButton = new Button(composite, 16);
        this.fAddVariableStringButton.setText(LauncherMessages.getString("RuntimeClasspathAdvancedDialog.6"));
        GridData gd = new GridData(768);
        this.fAddVariableStringButton.setLayoutData((Object)gd);
        Composite inner = new Composite(composite, 0);
        inner.setLayout((Layout)new GridLayout(2, false));
        inner.setLayoutData((Object)new GridData(768));
        this.fVariableString = new Text(inner, 2052);
        gd = new GridData(768);
        gd.grabExcessHorizontalSpace = true;
        this.fVariableString.setLayoutData((Object)gd);
        final Button fVariablesButton = this.createButton(inner, 9, LauncherMessages.getString("RuntimeClasspathAdvancedDialog.7"), false);
        gd = new GridData(32);
        fVariablesButton.setLayoutData((Object)gd);
        fVariablesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StringVariableSelectionDialog dialog = new StringVariableSelectionDialog(RuntimeClasspathAdvancedDialog.this.getShell());
                dialog.open();
                String variable = dialog.getVariableExpression();
                if (variable != null) {
                    RuntimeClasspathAdvancedDialog.this.fVariableString.append(variable);
                }
            }
        });
        this.fAddVariableStringButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean enabled = RuntimeClasspathAdvancedDialog.this.fAddVariableStringButton.getSelection();
                RuntimeClasspathAdvancedDialog.this.fVariableString.setEnabled(enabled);
                fVariablesButton.setEnabled(enabled);
            }
        });
        boolean enabled = this.fAddVariableStringButton.getSelection();
        this.fVariableString.setEnabled(enabled);
        fVariablesButton.setEnabled(enabled);
    }

    protected void okPressed() {
        block3: {
            block2: {
                if (!this.fAddVariableStringButton.getSelection()) break block2;
                String varString = this.fVariableString.getText().trim();
                if (varString.length() <= 0) break block3;
                IRuntimeClasspathEntry entry = JavaRuntime.newStringVariableClasspathEntry((String)varString);
                this.fViewer.addEntries(new IRuntimeClasspathEntry[]{entry});
                break block3;
            }
            for (int i = 0; i < this.fButtons.length; ++i) {
                if (!this.fButtons[i].getSelection()) continue;
                IAction action = (IAction)this.fButtons[i].getData();
                if (action instanceof RuntimeClasspathAction) {
                    ((RuntimeClasspathAction)action).setShell(this.getShell());
                }
                action.run();
                break;
            }
        }
        super.okPressed();
    }

    protected String getDialogSettingsSectionName() {
        return IJavaDebugUIConstants.PLUGIN_ID + ".RUNTIME_CLASSPATH_ADVANCED_DIALOG";
    }

    protected Point getInitialSize() {
        return DialogSettingsHelper.getInitialSize(this.getDialogSettingsSectionName(), super.getInitialSize());
    }

    protected Point getInitialLocation(Point initialSize) {
        Point point = DialogSettingsHelper.getInitialLocation(this.getDialogSettingsSectionName());
        return point != null ? point : super.getInitialLocation(initialSize);
    }

    public boolean close() {
        DialogSettingsHelper.persistShellGeometry(this.getShell(), this.getDialogSettingsSectionName());
        return super.close();
    }
}

