/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionDelta;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.IRegistryChangeListener;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.help.IHelpContentProducer;
import org.eclipse.help.internal.HelpPlugin;
import org.eclipse.help.internal.HelpResources;
import org.osgi.framework.Bundle;

public class ResourceLocator {
    public static final String CONTENTPRODUCER_XP_NAME = "contentProducer";
    public static final String CONTENTPRODUCER_XP_FULLNAME = "org.eclipse.help.contentProducer";
    private static Hashtable zipCache = new Hashtable();
    private static final Object ZIP_NOT_FOUND;
    private static final Object STATIC_DOCS_ONLY;
    private static Map contentProducers;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static IHelpContentProducer getContentProducer(String pluginId) {
        Map map = contentProducers;
        synchronized (map) {
            Object producer = contentProducers.get(pluginId);
            if (producer == null) {
                producer = ResourceLocator.createContentProducer(pluginId);
                if (producer == null) {
                    producer = STATIC_DOCS_ONLY;
                }
                contentProducers.put(pluginId, producer);
            }
            if (producer == STATIC_DOCS_ONLY) {
                return null;
            }
            return (IHelpContentProducer)producer;
        }
    }

    private static IHelpContentProducer createContentProducer(String pluginId) {
        IExtensionPoint xp = Platform.getExtensionRegistry().getExtensionPoint(CONTENTPRODUCER_XP_FULLNAME);
        if (xp == null) {
            return null;
        }
        IExtension[] extensions = xp.getExtensions();
        for (int i = 0; i < extensions.length; ++i) {
            if (!extensions[i].getNamespace().equals(pluginId)) continue;
            IConfigurationElement[] elements = extensions[i].getConfigurationElements();
            for (int j = 0; j < elements.length; ++j) {
                if (!CONTENTPRODUCER_XP_NAME.equals(elements[j].getName())) continue;
                try {
                    Object o = elements[j].createExecutableExtension("producer");
                    if (!(o instanceof IHelpContentProducer)) continue;
                    return (IHelpContentProducer)o;
                }
                catch (CoreException ce) {
                    HelpPlugin.logError(HelpResources.getString("E044", pluginId), ce);
                }
            }
        }
        return null;
    }

    public static InputStream openFromProducer(Bundle pluginDesc, String file, String locale) {
        IHelpContentProducer producer = ResourceLocator.getContentProducer(pluginDesc.getSymbolicName());
        if (producer == null) {
            return null;
        }
        if (locale == null || locale.length() <= 0) {
            locale = Platform.getNL();
        }
        Locale l = locale.length() >= 5 ? new Locale(locale.substring(0, 2), locale.substring(3, 5)) : (locale.length() >= 2 ? new Locale(locale.substring(0, 2), "") : Locale.getDefault());
        return producer.getInputStream(pluginDesc.getSymbolicName(), file, l);
    }

    public static InputStream openFromPlugin(String pluginId, String file, String locale) {
        Bundle bundle = Platform.getBundle((String)pluginId);
        if (bundle != null) {
            return ResourceLocator.openFromPlugin(Platform.getBundle((String)pluginId), file, locale);
        }
        return null;
    }

    public static InputStream openFromZip(Bundle pluginDesc, String zip, String file, String locale) {
        InputStream is = ResourceLocator.doOpenFromZip(pluginDesc, "$nl$/" + zip, file, locale);
        if (is == null) {
            is = ResourceLocator.doOpenFromZip(pluginDesc, zip, file, locale);
        }
        return is;
    }

    public static InputStream openFromPlugin(Bundle pluginDesc, String file, String locale) {
        InputStream is = ResourceLocator.doOpenFromPlugin(pluginDesc, "$nl$/" + file, locale);
        if (is == null) {
            is = ResourceLocator.doOpenFromPlugin(pluginDesc, file, locale);
        }
        return is;
    }

    private static InputStream doOpenFromZip(Bundle pluginDesc, String zip, String file, String locale) {
        String realZipURL = ResourceLocator.findZip(pluginDesc, zip, locale);
        if (realZipURL == null) {
            return null;
        }
        try {
            URL jurl = new URL("jar", "", realZipURL + "!/" + file);
            URLConnection jconnection = jurl.openConnection();
            jconnection.setDefaultUseCaches(false);
            jconnection.setUseCaches(false);
            return jconnection.getInputStream();
        }
        catch (IOException ioe) {
            return null;
        }
    }

    private static InputStream doOpenFromPlugin(Bundle pluginDesc, String file, String locale) {
        Path flatFilePath = new Path(file);
        HashMap<String, String> override = new HashMap<String, String>(1);
        override.put("$nl$", locale);
        URL flatFileURL = Platform.find((Bundle)pluginDesc, (IPath)flatFilePath, override);
        if (flatFileURL != null) {
            try {
                return flatFileURL.openStream();
            }
            catch (IOException e) {
                return null;
            }
        }
        return null;
    }

    private static String findZip(Bundle pluginDesc, String zip, String locale) {
        Hashtable cache = zipCache;
        String pluginID = pluginDesc.getSymbolicName();
        Object cached = cache.get(pluginID + '/' + zip + '/' + locale);
        if (cached == null) {
            Path zipFilePath = new Path(zip);
            HashMap<String, String> override = new HashMap<String, String>(1);
            override.put("$nl$", locale);
            try {
                URL zipFileURL = Platform.find((Bundle)pluginDesc, (IPath)zipFilePath, override);
                if (zipFileURL != null) {
                    URL realZipURL = Platform.asLocalURL((URL)Platform.resolve((URL)zipFileURL));
                    cached = realZipURL.toExternalForm();
                } else {
                    cached = ZIP_NOT_FOUND;
                }
            }
            catch (IOException ioe) {
                cached = ZIP_NOT_FOUND;
            }
            cache.put(pluginID + '/' + zip + '/' + locale, cached);
        }
        if (cached == ZIP_NOT_FOUND) {
            return null;
        }
        return (String)cached;
    }

    public static void clearZipCache() {
        zipCache = new Hashtable();
    }

    static {
        STATIC_DOCS_ONLY = ZIP_NOT_FOUND = new Object();
        contentProducers = new HashMap(2, 0.5f);
        Platform.getExtensionRegistry().addRegistryChangeListener(new IRegistryChangeListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void registryChanged(IRegistryChangeEvent event) {
                IExtensionDelta[] deltas = event.getExtensionDeltas("org.eclipse.help", ResourceLocator.CONTENTPRODUCER_XP_NAME);
                for (int i = 0; i < deltas.length; ++i) {
                    IExtension extension = deltas[i].getExtension();
                    String affectedPlugin = extension.getNamespace();
                    Map map = contentProducers;
                    synchronized (map) {
                        contentProducers.remove(affectedPlugin);
                        continue;
                    }
                }
            }
        });
    }
}

