/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Properties;

public class SecureAction {
    public static String getProperty(final String property) {
        if (System.getSecurityManager() == null) {
            return System.getProperty(property);
        }
        return (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty(property);
            }
        });
    }

    public static String getProperty(final String property, final String def) {
        if (System.getSecurityManager() == null) {
            return System.getProperty(property, def);
        }
        return (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty(property, def);
            }
        });
    }

    public static Properties getProperties() {
        if (System.getSecurityManager() == null) {
            return System.getProperties();
        }
        return (Properties)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperties();
            }
        });
    }

    public static FileInputStream getFileInputStream(final File file) throws FileNotFoundException {
        if (System.getSecurityManager() == null) {
            return new FileInputStream(file);
        }
        try {
            return (FileInputStream)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws FileNotFoundException {
                    return new FileInputStream(file);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (FileNotFoundException)e.getException();
        }
    }

    public static FileOutputStream getFileOutputStream(final File file, final boolean append) throws FileNotFoundException {
        if (System.getSecurityManager() == null) {
            return new FileOutputStream(file.getAbsolutePath(), append);
        }
        try {
            return (FileOutputStream)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws FileNotFoundException {
                    return new FileOutputStream(file.getAbsolutePath(), append);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (FileNotFoundException)e.getException();
        }
    }

    public static Thread createThread(final Runnable target, final String name) {
        if (System.getSecurityManager() == null) {
            return new Thread(target, name);
        }
        return (Thread)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return new Thread(target, name);
            }
        });
    }
}

