/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.builder;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Locale;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.internal.compiler.ClassFile;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.Compiler;
import org.eclipse.jdt.internal.compiler.DefaultErrorHandlingPolicies;
import org.eclipse.jdt.internal.compiler.ICompilerRequestor;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.problem.AbortCompilation;
import org.eclipse.jdt.internal.compiler.util.Util;
import org.eclipse.jdt.internal.core.builder.BuildNotifier;
import org.eclipse.jdt.internal.core.builder.ClasspathMultiDirectory;
import org.eclipse.jdt.internal.core.builder.ImageBuilderInternalException;
import org.eclipse.jdt.internal.core.builder.JavaBuilder;
import org.eclipse.jdt.internal.core.builder.MissingClassFileException;
import org.eclipse.jdt.internal.core.builder.NameEnvironment;
import org.eclipse.jdt.internal.core.builder.ProblemFactory;
import org.eclipse.jdt.internal.core.builder.SourceFile;
import org.eclipse.jdt.internal.core.builder.State;
import org.eclipse.jdt.internal.core.builder.WorkQueue;

public abstract class AbstractImageBuilder
implements ICompilerRequestor {
    protected JavaBuilder javaBuilder;
    protected State newState;
    protected NameEnvironment nameEnvironment;
    protected ClasspathMultiDirectory[] sourceLocations;
    protected BuildNotifier notifier;
    protected Compiler compiler;
    protected WorkQueue workQueue;
    protected ArrayList problemSourceFiles;
    protected boolean compiledAllAtOnce;
    private boolean inCompiler;
    public static int MAX_AT_ONCE = 1000;

    protected AbstractImageBuilder(JavaBuilder javaBuilder) {
        this.javaBuilder = javaBuilder;
        this.newState = new State(javaBuilder);
        this.nameEnvironment = javaBuilder.nameEnvironment;
        this.sourceLocations = this.nameEnvironment.sourceLocations;
        this.notifier = javaBuilder.notifier;
        this.compiler = this.newCompiler();
        this.workQueue = new WorkQueue();
        this.problemSourceFiles = new ArrayList(3);
    }

    public void acceptResult(CompilationResult result) {
        SourceFile compilationUnit = (SourceFile)result.getCompilationUnit();
        if (!this.workQueue.isCompiled(compilationUnit)) {
            this.workQueue.finished(compilationUnit);
            try {
                this.updateProblemsFor(compilationUnit, result);
                this.updateTasksFor(compilationUnit, result);
            }
            catch (CoreException e) {
                throw this.internalException(e);
            }
            String typeLocator = compilationUnit.typeLocator();
            ClassFile[] classFiles = result.getClassFiles();
            int length = classFiles.length;
            ArrayList<char[][]> duplicateTypeNames = null;
            ArrayList<char[]> definedTypeNames = new ArrayList<char[]>(length);
            for (int i = 0; i < length; ++i) {
                String qualifiedTypeName;
                boolean isNestedType;
                ClassFile classFile = classFiles[i];
                char[][] compoundName = classFile.getCompoundName();
                char[] typeName = compoundName[compoundName.length - 1];
                boolean bl = isNestedType = classFile.enclosingClassFile != null;
                if (isNestedType) {
                    qualifiedTypeName = new String(classFile.outerMostEnclosingClassFile().fileName());
                    if (this.newState.isDuplicateLocator(qualifiedTypeName, typeLocator)) {
                        continue;
                    }
                } else {
                    qualifiedTypeName = new String(classFile.fileName());
                    if (this.newState.isDuplicateLocator(qualifiedTypeName, typeLocator)) {
                        if (duplicateTypeNames == null) {
                            duplicateTypeNames = new ArrayList<char[][]>();
                        }
                        duplicateTypeNames.add(compoundName);
                        this.createProblemFor((IResource)compilationUnit.resource, org.eclipse.jdt.internal.core.util.Util.bind("build.duplicateClassFile", new String(typeName)), "error");
                        continue;
                    }
                    this.newState.recordLocatorForType(qualifiedTypeName, typeLocator);
                }
                try {
                    definedTypeNames.add(this.writeClassFile(classFile, compilationUnit, !isNestedType));
                    continue;
                }
                catch (CoreException e) {
                    org.eclipse.jdt.internal.core.util.Util.log(e, "JavaBuilder handling CoreException");
                    if (e.getStatus().getCode() == 275) {
                        this.createProblemFor((IResource)compilationUnit.resource, org.eclipse.jdt.internal.core.util.Util.bind("build.classFileCollision", e.getMessage()), "error");
                        continue;
                    }
                    this.createProblemFor((IResource)compilationUnit.resource, org.eclipse.jdt.internal.core.util.Util.bind("build.inconsistentClassFile"), "error");
                }
            }
            this.finishedWith(typeLocator, result, compilationUnit.getMainTypeName(), definedTypeNames, duplicateTypeNames);
            this.notifier.compiled(compilationUnit);
        }
    }

    protected void cleanUp() {
        this.nameEnvironment.cleanup();
        this.javaBuilder = null;
        this.nameEnvironment = null;
        this.sourceLocations = null;
        this.notifier = null;
        this.compiler = null;
        this.workQueue = null;
        this.problemSourceFiles = null;
    }

    protected void compile(SourceFile[] units) {
        int unitsLength = units.length;
        boolean bl = this.compiledAllAtOnce = unitsLength <= MAX_AT_ONCE;
        if (this.compiledAllAtOnce) {
            if (JavaBuilder.DEBUG) {
                for (int i = 0; i < unitsLength; ++i) {
                    System.out.println("About to compile " + units[i].typeLocator());
                }
            }
            this.compile(units, null);
        } else {
            int i = 0;
            boolean compilingFirstGroup = true;
            while (i < unitsLength) {
                int doNow = unitsLength < MAX_AT_ONCE ? unitsLength : MAX_AT_ONCE;
                int index = 0;
                SourceFile[] toCompile = new SourceFile[doNow];
                while (i < unitsLength && index < doNow) {
                    SourceFile unit = units[i++];
                    if (!compilingFirstGroup && !this.workQueue.isWaiting(unit)) continue;
                    if (JavaBuilder.DEBUG) {
                        System.out.println("About to compile " + unit.typeLocator());
                    }
                    toCompile[index++] = unit;
                }
                if (index < doNow) {
                    SourceFile[] sourceFileArray = toCompile;
                    toCompile = new SourceFile[index];
                    System.arraycopy(sourceFileArray, 0, toCompile, 0, index);
                }
                SourceFile[] additionalUnits = new SourceFile[unitsLength - i];
                System.arraycopy(units, i, additionalUnits, 0, additionalUnits.length);
                compilingFirstGroup = false;
                this.compile(toCompile, additionalUnits);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void compile(SourceFile[] units, SourceFile[] additionalUnits) {
        if (units.length == 0) {
            return;
        }
        this.notifier.aboutToCompile(units[0]);
        if (!this.problemSourceFiles.isEmpty()) {
            int length;
            int toAdd = this.problemSourceFiles.size();
            int n = length = additionalUnits == null ? 0 : additionalUnits.length;
            if (length == 0) {
                additionalUnits = new SourceFile[toAdd];
            } else {
                SourceFile[] sourceFileArray = additionalUnits;
                additionalUnits = new SourceFile[length + toAdd];
                System.arraycopy(sourceFileArray, 0, additionalUnits, 0, length);
            }
            for (int i = 0; i < toAdd; ++i) {
                additionalUnits[length + i] = (SourceFile)this.problemSourceFiles.get(i);
            }
        }
        String[] initialTypeNames = new String[units.length];
        int l = units.length;
        for (int i = 0; i < l; ++i) {
            initialTypeNames[i] = units[i].initialTypeName;
        }
        this.nameEnvironment.setNames(initialTypeNames, additionalUnits);
        this.notifier.checkCancel();
        try {
            this.inCompiler = true;
            this.compiler.compile(units);
        }
        catch (AbortCompilation ignored) {
        }
        finally {
            this.inCompiler = false;
        }
        this.notifier.checkCancel();
    }

    protected void createProblemFor(IResource resource, String message, String problemSeverity) {
        try {
            IMarker marker = resource.createMarker("org.eclipse.jdt.core.problem");
            int severity = problemSeverity.equals("warning") ? 1 : 2;
            marker.setAttributes(new String[]{"message", "severity", "charStart", "charEnd"}, new Object[]{message, new Integer(severity), new Integer(0), new Integer(1)});
        }
        catch (CoreException e) {
            throw this.internalException(e);
        }
    }

    protected void finishedWith(String sourceLocator, CompilationResult result, char[] mainTypeName, ArrayList definedTypeNames, ArrayList duplicateTypeNames) {
        if (duplicateTypeNames == null) {
            this.newState.record(sourceLocator, result.qualifiedReferences, result.simpleNameReferences, mainTypeName, definedTypeNames);
            return;
        }
        char[][][] qualifiedRefs = result.qualifiedReferences;
        Object simpleRefs = result.simpleNameReferences;
        int l = duplicateTypeNames.size();
        block0: for (int i = 0; i < l; ++i) {
            char[][] compoundName = (char[][])duplicateTypeNames.get(i);
            char[] typeName = compoundName[compoundName.length - 1];
            int sLength = ((char[][])simpleRefs).length;
            for (int j = 0; j < sLength; ++j) {
                if (CharOperation.equals(simpleRefs[j], typeName)) continue block0;
            }
            char[][] cArray = simpleRefs;
            char[][] cArrayArray = new char[sLength + 1][];
            simpleRefs = cArrayArray;
            System.arraycopy(cArray, 0, cArrayArray, 0, sLength);
            simpleRefs[sLength] = typeName;
        }
        this.newState.record(sourceLocator, qualifiedRefs, (char[][])simpleRefs, mainTypeName, definedTypeNames);
    }

    protected IContainer createFolder(IPath packagePath, IContainer outputFolder) throws CoreException {
        if (packagePath.isEmpty()) {
            return outputFolder;
        }
        IFolder folder = outputFolder.getFolder(packagePath);
        if (!folder.exists()) {
            this.createFolder(packagePath.removeLastSegments(1), outputFolder);
            folder.create(true, true, null);
            folder.setDerived(true);
        }
        return folder;
    }

    protected RuntimeException internalException(CoreException t) {
        ImageBuilderInternalException imageBuilderException = new ImageBuilderInternalException(t);
        if (this.inCompiler) {
            return new AbortCompilation(true, imageBuilderException);
        }
        return imageBuilderException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Compiler newCompiler() {
        LookupEnvironment env;
        Compiler newCompiler = new Compiler(this.nameEnvironment, DefaultErrorHandlingPolicies.proceedWithAllProblems(), this.javaBuilder.javaProject.getOptions(true), this, ProblemFactory.getProblemFactory(Locale.getDefault()));
        newCompiler.options.produceReferenceInfo = true;
        LookupEnvironment lookupEnvironment = env = newCompiler.lookupEnvironment;
        synchronized (lookupEnvironment) {
            env.sharedArraysUsed = false;
            env.sharedClassFileHeader = new byte[30000];
            env.sharedClassFileContents = new byte[30000];
        }
        return newCompiler;
    }

    protected boolean isExcludedFromProject(IPath childPath) throws JavaModelException {
        if (childPath.segmentCount() > 2) {
            return false;
        }
        int k = this.sourceLocations.length;
        for (int j = 0; j < k; ++j) {
            if (childPath.equals(this.sourceLocations[j].binaryFolder.getFullPath())) {
                return true;
            }
            if (!childPath.equals(this.sourceLocations[j].sourceFolder.getFullPath())) continue;
            return true;
        }
        return childPath.equals(this.javaBuilder.javaProject.getOutputLocation());
    }

    protected void storeProblemsFor(SourceFile sourceFile, IProblem[] problems) throws CoreException {
        if (sourceFile == null || problems == null || problems.length == 0) {
            return;
        }
        String missingClassFile = null;
        IFile resource = sourceFile.resource;
        int l = problems.length;
        for (int i = 0; i < l; ++i) {
            IProblem problem = problems[i];
            int id = problem.getID();
            switch (id) {
                case 0x1000144: {
                    JavaBuilder.removeProblemsAndTasksFor((IResource)this.javaBuilder.currentProject);
                    String[] args = problem.getArguments();
                    missingClassFile = args[0];
                    break;
                }
                case 16777528: 
                case 16777531: 
                case 16777532: 
                case 16777533: 
                case 16777543: 
                case 16777546: 
                case 16777547: 
                case 16777548: 
                case 16777549: 
                case 16777550: 
                case 16777551: 
                case 0x1000150: 
                case 0x1000151: 
                case 16777554: 
                case 16777555: {
                    if (this.problemSourceFiles.contains(sourceFile)) break;
                    this.problemSourceFiles.add(sourceFile);
                }
            }
            if (id != 536871362) {
                IMarker marker = resource.createMarker("org.eclipse.jdt.core.problem");
                marker.setAttributes(new String[]{"message", "severity", "id", "charStart", "charEnd", "lineNumber", "arguments"}, new Object[]{problem.getMessage(), new Integer(problem.isError() ? 2 : 1), new Integer(id), new Integer(problem.getSourceStart()), new Integer(problem.getSourceEnd() + 1), new Integer(problem.getSourceLineNumber()), org.eclipse.jdt.internal.core.util.Util.getProblemArgumentsForMarker(problem.getArguments())});
            }
            if (missingClassFile == null) continue;
            throw new MissingClassFileException(missingClassFile);
        }
    }

    protected void storeTasksFor(SourceFile sourceFile, IProblem[] tasks) throws CoreException {
        if (sourceFile == null || tasks == null || tasks.length == 0) {
            return;
        }
        IFile resource = sourceFile.resource;
        int l = tasks.length;
        for (int i = 0; i < l; ++i) {
            IProblem task = tasks[i];
            if (task.getID() != 536871362) continue;
            IMarker marker = resource.createMarker("org.eclipse.jdt.core.task");
            int priority = 1;
            String compilerPriority = task.getArguments()[2];
            if ("HIGH".equals(compilerPriority)) {
                priority = 2;
            } else if ("LOW".equals(compilerPriority)) {
                priority = 0;
            }
            marker.setAttributes(new String[]{"message", "priority", "done", "charStart", "charEnd", "lineNumber", "userEditable"}, new Object[]{task.getMessage(), new Integer(priority), Util.toBoolean(false), new Integer(task.getSourceStart()), new Integer(task.getSourceEnd() + 1), new Integer(task.getSourceLineNumber()), new Boolean(false)});
        }
    }

    protected void updateProblemsFor(SourceFile sourceFile, CompilationResult result) throws CoreException {
        IProblem[] problems = result.getProblems();
        if (problems == null || problems.length == 0) {
            return;
        }
        this.notifier.updateProblemCounts(problems);
        this.storeProblemsFor(sourceFile, problems);
    }

    protected void updateTasksFor(SourceFile sourceFile, CompilationResult result) throws CoreException {
        IProblem[] tasks = result.getTasks();
        if (tasks == null || tasks.length == 0) {
            return;
        }
        this.storeTasksFor(sourceFile, tasks);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected char[] writeClassFile(ClassFile classFile, SourceFile compilationUnit, boolean isSecondaryType) throws CoreException {
        IContainer outputFolder;
        String fileName = new String(classFile.fileName());
        Path filePath = new Path(fileName);
        IContainer container = outputFolder = compilationUnit.sourceLocation.binaryFolder;
        if (filePath.segmentCount() > 1) {
            container = this.createFolder(filePath.removeLastSegments(1), outputFolder);
            filePath = new Path(filePath.lastSegment());
        }
        IFile file = container.getFile(filePath.addFileExtension("class"));
        this.writeClassFileBytes(classFile.getBytes(), file, fileName, isSecondaryType, compilationUnit.updateClassFile);
        if (classFile.ownSharedArrays) {
            LookupEnvironment env;
            LookupEnvironment lookupEnvironment = env = this.compiler.lookupEnvironment;
            synchronized (lookupEnvironment) {
                env.sharedArraysUsed = false;
            }
        }
        return filePath.lastSegment().toCharArray();
    }

    protected void writeClassFileBytes(byte[] bytes, IFile file, String qualifiedFileName, boolean isSecondaryType, boolean updateClassFile) throws CoreException {
        if (file.exists()) {
            if (JavaBuilder.DEBUG) {
                System.out.println("Writing changed class file " + file.getName());
            }
            file.setContents((InputStream)new ByteArrayInputStream(bytes), true, false, null);
            if (!file.isDerived()) {
                file.setDerived(true);
            }
        } else {
            if (JavaBuilder.DEBUG) {
                System.out.println("Writing new class file " + file.getName());
            }
            file.create((InputStream)new ByteArrayInputStream(bytes), 1, null);
            file.setDerived(true);
        }
    }
}

