/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.progress;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.progress.UIJob;

class WorkbenchMonitorProvider {
    WorkbenchMonitorProvider() {
    }

    IProgressMonitor getMonitor(Job job) {
        if (job instanceof UIJob) {
            return this.getUIProgressMonitor(job.getName());
        }
        return new NullProgressMonitor();
    }

    private IStatusLineManager getStatusLineManager() {
        IWorkbenchWindow window;
        if (PlatformUI.isWorkbenchRunning() && (window = PlatformUI.getWorkbench().getActiveWorkbenchWindow()) != null && window instanceof WorkbenchWindow) {
            return ((WorkbenchWindow)window).getStatusLineManager();
        }
        return null;
    }

    private IProgressMonitor getUIProgressMonitor(final String jobName) {
        return new IProgressMonitor(){
            IProgressMonitor internalMonitor;

            public void beginTask(String name, int totalWork) {
                if (name == null || name.length() == 0) {
                    this.getInternalMonitor().beginTask(jobName, totalWork);
                } else {
                    this.getInternalMonitor().beginTask(name, totalWork);
                }
            }

            public void done() {
                this.getInternalMonitor().done();
            }

            public void internalWorked(double work) {
                this.getInternalMonitor().internalWorked(work);
            }

            public boolean isCanceled() {
                return this.getInternalMonitor().isCanceled();
            }

            public void setCanceled(boolean value) {
                this.getInternalMonitor().setCanceled(value);
            }

            public void setTaskName(String name) {
                this.getInternalMonitor().setTaskName(name);
            }

            public void subTask(String name) {
                this.getInternalMonitor().subTask(name);
            }

            public void worked(int work) {
                this.getInternalMonitor().worked(work);
            }

            private IProgressMonitor getInternalMonitor() {
                if (this.internalMonitor == null) {
                    IStatusLineManager manager = WorkbenchMonitorProvider.this.getStatusLineManager();
                    this.internalMonitor = manager == null ? new NullProgressMonitor() : manager.getProgressMonitor();
                }
                return this.internalMonitor;
            }
        };
    }
}

