/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.actions;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.internal.Workbench;
import org.eclipse.ui.internal.WorkbenchMessages;

public class OpenInNewWindowAction
extends Action
implements ActionFactory.IWorkbenchAction {
    private IWorkbenchWindow workbenchWindow;
    private IAdaptable pageInput;

    public OpenInNewWindowAction(IWorkbenchWindow window) {
        this(window, ((Workbench)window.getWorkbench()).getDefaultPageInput());
    }

    public OpenInNewWindowAction(IWorkbenchWindow window, IAdaptable input) {
        super(WorkbenchMessages.getString("OpenInNewWindowAction.text"));
        if (window == null) {
            throw new IllegalArgumentException();
        }
        this.workbenchWindow = window;
        this.setToolTipText(WorkbenchMessages.getString("OpenInNewWindowAction.toolTip"));
        this.pageInput = input;
        WorkbenchHelp.setHelp((IAction)this, "org.eclipse.ui.open_new_window_action_context");
    }

    public void setPageInput(IAdaptable input) {
        this.pageInput = input;
    }

    public void run() {
        if (this.workbenchWindow == null) {
            return;
        }
        try {
            IWorkbenchPage page = this.workbenchWindow.getActivePage();
            String perspId = page != null && page.getPerspective() != null ? page.getPerspective().getId() : this.workbenchWindow.getWorkbench().getPerspectiveRegistry().getDefaultPerspective();
            this.workbenchWindow.getWorkbench().openWorkbenchWindow(perspId, this.pageInput);
        }
        catch (WorkbenchException e) {
            ErrorDialog.openError((Shell)this.workbenchWindow.getShell(), (String)WorkbenchMessages.getString("OpenInNewWindowAction.errorTitle"), (String)e.getMessage(), (IStatus)e.getStatus());
        }
    }

    public void dispose() {
        this.workbenchWindow = null;
    }
}

