#include <time.h>

#include "liblif.h"

#define bcd_to_dec(bcd)							\
	(((((u_int32_t)(bcd)) & 0xf0)>>4)*10 + ((bcd) & 0x0f))

#define dec_to_bcd(dec)							\
	( ((((dec)/10) << 4) & 0xf0) | ((((u_int32_t)(dec)) % 10) & 0x0f) )

void
lif_gettime(struct liftoc *toc, struct tm *tval)
{
	struct tm tm;
	time_t tmt;

	tm.tm_sec = bcd_to_dec(toc->toc_second);
	tm.tm_min = bcd_to_dec(toc->toc_minute);
	tm.tm_hour = bcd_to_dec(toc->toc_hour);
	tm.tm_mday = bcd_to_dec(toc->toc_day);
	tm.tm_mon = bcd_to_dec(toc->toc_month)-1;
	tm.tm_year = bcd_to_dec(toc->toc_year);

	tmt = mktime(&tm);
	gmtime_r(&tmt, tval);
}

void
lif_puttime(struct liftoc *toc, struct tm *tval)
{

	memset(toc, 0, sizeof(struct liftoc));
	toc->toc_second = dec_to_bcd(tval->tm_sec);
	toc->toc_minute = dec_to_bcd(tval->tm_min);
	toc->toc_hour = dec_to_bcd(tval->tm_hour);
	toc->toc_day = dec_to_bcd(tval->tm_mday);
	toc->toc_month = dec_to_bcd(tval->tm_mon)+1;
	toc->toc_year = dec_to_bcd(tval->tm_year);
}
